const fs = require('fs');

// Fonction pour corriger manuellement le fichier geoloc.js
function fixGeolocFile() {
  const filePath = '/home/project/js/geoloc.js';
  
  if (!fs.existsSync(filePath)) {
    console.error(`Fichier non trouvé: ${filePath}`);
    return;
  }
  
  try {
    let content = fs.readFileSync(filePath, 'utf8');
    
    // Rechercher et corriger les occurrences spécifiques qui pourraient causer l'erreur
    
    // 1. Corriger "console.log(`Distance "directe" calculée pour ID ${id}: ${distanceKm.toFixed(1)} km`);"
    content = content.replace(
      /console\.log\(`Distance "directe" calculée pour ID \${id}: \${distanceKm\.toFixed\(1\)} km`\);/g,
      'console.log(`Distance "directe" calculée pour ID ${id}: ${distanceKm.toFixed(1)} km`);'
    );
    
    // 2. Corriger "console.log(`Utilisation du fallback pour ID ${id}: ${distanceKm.toFixed(1)} km`);"
    content = content.replace(
      /console\.log\(`Utilisation du fallback pour ID \${id}: \${distanceKm\.toFixed\(1\)} km`\);/g,
      'console.log(`Utilisation du fallback pour ID ${id}: ${distanceKm.toFixed(1)} km`);'
    );
    
    // 3. Corriger "// Fallback: distance directe"
    content = content.replace(
      /\/\/ Fallback: distance "directe"/g,
      '// Fallback: distance directe'
    );
    
    // 4. Corriger les commentaires contenant "distance directe"
    content = content.replace(
      /console\.warn\(`Structure de réponse inattendue pour ID \${id}, utilisation du fallback`\);/g,
      'console.warn(`Structure de réponse inattendue pour ID ${id}, utilisation du fallback`);'
    );
    
    // 5. Corriger les commentaires contenant "distance "directe" par défaut"
    content = content.replace(
      /let distanceKm = haversineDistance; \/\/ Utiliser la distance "directe" par défaut/g,
      'let distanceKm = haversineDistance; // Utiliser la distance "directe" par défaut'
    );
    
    // 6. Corriger les commentaires contenant "distance directe"
    content = content.replace(
      /const haversineDistance = calculateHaversineDistance\(userLat, userLng, farmLat, farmLng\);/g,
      'const haversineDistance = calculateHaversineDistance(userLat, userLng, farmLat, farmLng);'
    );
    
    // Écrire le contenu corrigé
    fs.writeFileSync(filePath, content, 'utf8');
    console.log(`✅ Corrections manuelles appliquées à: ${filePath}`);
    
  } catch (err) {
    console.error(`Erreur lors de la correction manuelle de ${filePath}: ${err}`);
  }
}

// Fonction pour corriger manuellement le fichier main.js
function fixMainFile() {
  const filePath = '/home/project/tmpl/assets/main.js';
  
  if (!fs.existsSync(filePath)) {
    console.error(`Fichier non trouvé: ${filePath}`);
    return;
  }
  
  try {
    let content = fs.readFileSync(filePath, 'utf8');
    
    // Rechercher et corriger les occurrences spécifiques qui pourraient causer l'erreur
    
    // 1. Corriger les commentaires contenant "distance directe"
    content = content.replace(
      /\/\/ Fallback: distance "directe"/g,
      '// Fallback: distance directe'
    );
    
    // 2. Corriger les commentaires contenant "distance "directe" (formule Haversine)"
    content = content.replace(
      /\/\/ Fonction pour calculer la distance "directe" \(formule Haversine\)/g,
      '// Fonction pour calculer la distance "directe" (formule Haversine)'
    );
    
    // Écrire le contenu corrigé
    fs.writeFileSync(filePath, content, 'utf8');
    console.log(`✅ Corrections manuelles appliquées à: ${filePath}`);
    
  } catch (err) {
    console.error(`Erreur lors de la correction manuelle de ${filePath}: ${err}`);
  }
}

console.log("Application des corrections manuelles...");
fixGeolocFile();
fixMainFile();
console.log("Corrections manuelles terminées.");
